% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

function MouseButton

%% Display Setup Module

% Define display parameters

whichScreen = max(Screen('screens'));
p.ScreenDistance = 30; 	% in inches
p.ScreenHeight = 15; 	% in inches
p.ScreenGamma = 2;	% from monitor calibration
p.maxLuminance = 100; % from monitor calibration
p.ScreenBackground = 0.5;

% Open the display window and hide the mouse cursor

if exist('onCleanup', 'class'), oC_Obj = onCleanup(@()sca); end % close any pre-existing PTB Screen window
PsychImaging('PrepareConfiguration'); 
PsychImaging('AddTask', 'General', 'FloatingPoint32BitIfPossible');   % set up a 32-bit framebuffer
PsychImaging('AddTask', 'General', 'NormalizedHighresColorRange');
PsychImaging('AddTask', 'FinalFormatting', 'DisplayColorCorrection', 'SimpleGamma');  % setup Gamma correction method
[windowPtr p.ScreenRect] = PsychImaging('OpenWindow', whichScreen, p.ScreenBackground);  % open a display window
PsychColorCorrection('SetEncodingGamma', windowPtr, 1 / p.ScreenGamma);  % set Gamma for all color channels
% HideCursor;

% Get frame rate and set screen font

p.ScreenFrameRate = FrameRate(windowPtr);
Screen('TextFont', windowPtr, 'Times'); 
Screen('TextSize', windowPtr, 24);

%% Experimental Module

% Draw a button with "Try Me" on it
buttonColor = [0 1 1];   % button color
tryme = 'Try Me';        % text to label a button
trymeRect = CenterRect([0 0 120 60], p.ScreenRect); 
                         % button rectangle
[x y] = RectCenter(trymeRect); % center of the rectangle
textRect = Screen('TextBounds', windowPtr, tryme); 
                         % size of text
xtryme = x- textRect(3) / 2;   % x position so the text is
                               % in the rect center
ytryme = y- textRect(4) / 2;
Screen('FillRect', windowPtr, buttonColor, trymeRect); 
                         % draw a "button"
Screen('DrawText', windowPtr, tryme, xtryme, ytryme, ...
      [1 1 1]);          % button label

% Draw a button with "Quit" on it with different text 
% color 
Quit = 'Quit';
quitButton = trymeRect - [0 1 0 1] * 200;
[x y] = RectCenter(quitButton);
textRect = Screen('TextBounds', windowPtr, Quit);
xquit = x - textRect(3) / 2;
yquit = y - textRect(4) / 2;
Screen('FillRect', windowPtr, buttonColor, quitButton); 
                         % quit "button"
Screen('DrawText', windowPtr, Quit, xquit, yquit, [1 0 0]);

% Show all the drawing. We don't clear buffer, since we will 
% over-draw at the same location. Otherwise, we need to
% redraw both buttons for each flip.
Screen('Flip', windowPtr, 0, 1);
while 1
    while 1 % wait till left button press
        [x, y, buttons] = GetMouse(windowPtr);
        if buttons(1), break; end
    end
    if IsInRect(x, y, trymeRect) 
                         % is the click on the TryMe button?
        Screen('FillRect', windowPtr, buttonColor/2, ...
               trymeRect);  % darken the button
        Screen('DrawText', windowPtr, tryme, xtryme, ...
               ytryme, [1 1 1]);
        Screen('Flip', windowPtr, 0, 1);
        while buttons(1) % wait till button release
            [x, y, buttons] = GetMouse(windowPtr);
        end
        Screen('FillRect', windowPtr, buttonColor, ...
               trymeRect);  % restore button color
        Screen('DrawText', windowPtr, tryme, xtryme, ...
               ytryme, [1 1 1]);
        Screen('Flip', windowPtr ,0, 1);
    elseif IsInRect(x, y, quitButton) 
            % is the click on the Quit button?
        Screen('FillRect', windowPtr, buttonColor/2, ...
               quitButton); % darken the button
        Screen('DrawText', windowPtr, Quit, xquit, yquit, ...
               [1 0 0]);
        Screen('Flip', windowPtr, 0, 1);
        while buttons(1)
            [x, y, buttons] = GetMouse(windowPtr);
        end
        Screen('FillRect', windowPtr, buttonColor, ...
               quitButton); % restore button color
        Screen('DrawText', windowPtr, Quit, xquit, yquit, ...
               [1 0 0]);
        Screen('Flip', windowPtr, 0, 1);

        % Exit if mouse on the Quit button and released
        if IsInRect(x, y, quitButton), break; end
    end
end


%% System Reinstatement Module

Priority(0);  % restore priority
sca; % close window and textures, restore color lookup table

